<?php
class ControllerModuleProductsCategory extends Controller {
	protected function index($setting) {
		$this->language->load('module/products_category');
 
	 	$this->data['heading_title'] = '';
 
		$this->data['setting'] = $setting;

		if (isset($setting['title'])) {
			$this->data['heading_title'] = $setting['title'][$this->config->get('config_language_id')];
		}

		if (!$this->data['heading_title']) { 		
			$this->data['heading_title'] = $this->language->get('heading_title');
		}
		
		$this->data['button_cart'] = $this->language->get('button_cart');
		
		$this->load->model('catalog/product');
		
		$this->load->model('tool/image');

		$this->data['products'] = array();
		
		$data = array('limit' => $setting['limit']);
		
		$add_related_products = isset($setting['add_related_products'])?$setting['add_related_products']:false;
		
		$force_category = isset($setting['category']) ? $setting['category'] : 0;

		// $this->data['show_add_to_cart'] = isset($setting['show_add_to_cart'])?$setting['show_add_to_cart']:false;

		if (isset($this->request->get['product_id'])) {
			$product_id = $this->request->get['product_id'];
		} else {
			$product_id = 0;
		}

		if (isset($this->request->get['path'])) {
			$categories = explode("_",$this->request->get['path']);
			$category_id = $categories[count($categories)-1];
			
			$only_show_in_blank_categories = isset($setting['only_show_in_blank_categories'])?$setting['only_show_in_blank_categories']:false;
			
			if ($only_show_in_blank_categories) {
				$search_options = array('filter_category_id' => $category_id,'start' => 0,'limit' => 1);			
				$products = $this->model_catalog_product->getProducts($search_options);
			
				if (!empty($products)) {
					return false;
				}
			}
			
		} else {
			$category_id = 0;
		}

		$results = $this->model_catalog_product->getProductsCategory($product_id,$category_id,$data['limit'],$add_related_products,$force_category);

		foreach ($results as $result) {
			if (empty($result)) { continue; }
			
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}

			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
					
			if ((float)$result['special']) { 
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
			
			$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'    	 => $result['name'],
				'startdate'  => $result['date_added'],
				'date_added' => $result['date_added'],
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
		
		if(empty($this->data['products'])) {
			return false;
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/featured.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/featured.tpl';
		} else {
			$this->template = 'default/template/module/featured.tpl';
		}

		$this->render();
	}
}
?>
